#include < amxmodx >
#include < amxmisc >
#include < nvault >
#include < cstrike >
#include < fakemeta >
#include < hamsandwich >
#include < dhudmessage >
#include < fun >
#include < sqlx >

#define PLUGIN "Army System (EA)"
#define VERSION "2.1.4"
#define AUTHOR "OverGame"

#pragma tabsize 0

new const cPrefix[] = "!t[!gASystem!t]!y"

new Handle:MYSQL_Tuple
new Handle:MYSQL_Connect

new g_ActiveMysql
new szPlayerMysql[33]

new gSteamId[33][35]

enum _:UsData
{
	gExp, gLevel, gBonus
};

enum _:score
{
	frags,
	Float:dmg,
	hs
};

new niceP[33][score]

new UserData[33][UsData]

new gMaxPlayers, exp1, exp2, g_MsgHud, g_Informer, cl_r, cl_g, cl_b, gDelDay, gVault, gType, gNiceP, nMoney, nExp, gMySQL[5]

new const gRankNames[][] = 
{
	"R_0", "R_1", "R_2", "R_3", "R_4", "R_5", "R_6", "R_7", "R_8", "R_9", "R_10", "R_11", "R_12", "R_13", "R_14",		
	"R_15", "R_16", "R_17", "R_18", "R_19", "R_20"
};

new const gLevels[] = 
{
	0, 15, 30, 60, 100, 180, 350, 750, 999, 1500, 2200, 2800, 3200, 3900, 4500, 5000, 5500, 6000, 7000, 8000
};

public plugin_cfg()
{
	new szCfgDir[64], szFile[192]
	get_configsdir(szCfgDir, charsmax(szCfgDir))
	formatex(szFile,charsmax(szFile),"%s/as_system.cfg",szCfgDir)
	if(file_exists(szFile))
		server_cmd("exec %s", szFile)
		
	if(get_pcvar_num(gType) != 1)
	{
        gVault = nvault_open("army_system")
	
        if (gVault == INVALID_HANDLE)
            set_fail_state("Error opening nVault!")
		
        nvault_prune(gVault, 0, get_systime() - (86400 * get_pcvar_num( gDelDay)))
	}
}

#include "army_system/native.inl"

public plugin_end()
{
    if(get_pcvar_num(gType) != 1)
        nvault_close(gVault)
}

public MYSQL_Load()
{
	new szHostname[30], szUsername[30], szPassword[30], szDatabase[30]
	new szError[512], szErr

	get_pcvar_string(gMySQL[1], szHostname, charsmax( szHostname ))
	get_pcvar_string(gMySQL[2], szUsername, charsmax( szUsername ))
	get_pcvar_string(gMySQL[3], szPassword, charsmax( szPassword ))
	get_pcvar_string(gMySQL[4], szDatabase, charsmax( szDatabase ))

	MYSQL_Tuple = SQL_MakeDbTuple(szHostname, szUsername, szPassword, szDatabase)
	MYSQL_Connect= SQL_Connect(MYSQL_Tuple, szErr, szError, charsmax( szError ))

	if(MYSQL_Connect == Empty_Handle)
		set_fail_state( szError )

	g_ActiveMysql = true
}

public event_round_end ()
{
    if(!get_pcvar_num(gNiceP))
	    return PLUGIN_HANDLED

	new Players[32], num, tmpf, Float:tmpd, tmpid
	get_players( Players, num )

	for( new i; i < 32; i++)
	{
		if ( niceP[i][frags] > tmpf )
		{
			tmpid = i
			tmpf = niceP[i][frags]
			tmpd = niceP[i][dmg]
		}
		else if ( niceP[i][frags] == tmpf && niceP[i][dmg] > tmpd)
		{
			tmpid = i
			tmpf = niceP[i][frags]
			tmpd = niceP[i][dmg]
		}
	}

	if ( tmpf > 0 )
	{
		new name[32], msg[1024];
		get_user_name(tmpid, name, 31);

		format(msg, charsmax(msg), "%L", LANG_PLAYER, "AS_N_MSG0", name, tmpf, floatround(tmpd, floatround_round))
		
		cs_set_user_money( tmpid, cs_get_user_money(tmpid) + get_pcvar_num(nMoney) )
		
		UserData[tmpid][gExp] += get_pcvar_num(nExp)
		
		ChatColor(0, "%L", LANG_PLAYER, "AS_N_MSG1", cPrefix, name, get_pcvar_num(nMoney), get_pcvar_num(nExp))
		
		set_dhudmessage(get_pcvar_num(cl_r), get_pcvar_num(cl_g), get_pcvar_num(cl_b), -1.0, 0.17, 0, 8.0, 1.0, 0.1, 0.1)
		show_dhudmessage(0, msg)
	}
	
	return PLUGIN_HANDLED
}

public hook_TakeDamage(Victim, inflictor, Attacker, Float:damage, damagebits)
{
    if(!get_pcvar_num(gNiceP))
	    return PLUGIN_HANDLED
		
	if( inflictor == Attacker )
		niceP[Attacker][dmg] += damage
	else
	{
		static classname[32]
		pev (inflictor, pev_classname, classname, 31)
		if( equal (classname, "grenade") )
			niceP[Attacker][dmg] += damage
	}

	if ( get_pdata_int(Victim, 75, 5) == HIT_HEAD )
		niceP[Attacker][hs]++

	return HAM_IGNORED
}

public event_round_start()
{
    if(!get_pcvar_num(gNiceP))
	    return PLUGIN_HANDLED
		
	for (new i; i < 32; i++)
		for ( new j; j < 3; j++)
			niceP[i][j] = 0
			
	return PLUGIN_HANDLED
}

public client_authorized(id)
{
    get_user_authid(id, gSteamId[id], charsmax(gSteamId[]))
}

public client_putinserver(id)
{
    UserData[id][gLevel] = 0
	UserData[id][gExp] = 0
	UserData[id][gBonus] = 0
	
	cmdGetInfo(id)
}

public client_disconnect(id)
{
	for ( new j; j < 3; j++)
		niceP[id][j] = 0

	cmdSaveInfo(id)
}

public cmdSaveInfo(id)
{
	if(get_pcvar_num(gType))
	{
		new Handle:szUpdate
		
		szUpdate = SQL_PrepareQuery(MYSQL_Connect, "UPDATE `asystem` SET `as_lvl` = '%d', `as_exp` = '%i', `as_bonus` = '%i' WHERE `asystem`.`as_steam` = '%s';", UserData[id][gLevel], UserData[id][gExp], UserData[id][gBonus], gSteamId[id])

		if(!SQL_Execute(szUpdate)) 
		{
			set_task(1.0, "cmdSaveInfo", id)
			check_level(id)
		}
	} else {
		new s_SaveLvl[40], s_SaveExp[40], s_SaveBonus[40], s_Level[64], s_Exp[64], s_Bonus[64]

		formatex(s_SaveLvl, charsmax(s_SaveLvl) , "%sRANK", gSteamId[id])
		formatex(s_Level, charsmax(s_Level), "%d", UserData[id][gLevel])
	
		formatex(s_SaveExp, charsmax(s_SaveExp) , "%sEXP", gSteamId[id])
		formatex(s_Exp, charsmax(s_Exp), "%d", UserData[id][gExp])
	
		formatex(s_SaveBonus, charsmax(s_SaveBonus) , "%sBONUS", gSteamId[id])
		formatex(s_Bonus, charsmax(s_Bonus), "%d", UserData[id][gBonus])
    
		nvault_set(gVault, s_SaveLvl, s_Level)
		nvault_set(gVault, s_SaveExp, s_Exp)
		nvault_set(gVault, s_SaveBonus, s_Bonus)
	}
}

public cmdGetInfo(id)
{
    if(get_pcvar_num(gType))
	{
	    if(!g_ActiveMysql)
	    {
		    set_task(1.0, "cmdGetInfo", id)
	    }

	    new szMYSQLName[35]
	    new Handle:szSelect
	    new szName[33]
	    get_user_name(id, szName, 32)

	    szSelect = SQL_PrepareQuery(MYSQL_Connect, "SELECT * FROM asystem")

	    if(!SQL_Execute(szSelect))
	    {
	    	set_task(1.0, "cmdGetInfo", id)
			check_level(id)
	    }

	    while(SQL_MoreResults(szSelect))
	    {
	        SQL_ReadResult(szSelect, 1, szMYSQLName, charsmax( szMYSQLName ))
	
	        if(equal(szMYSQLName, gSteamId[id]))
	        {
				UserData[id][gLevel] = SQL_ReadResult(szSelect, 3)
				UserData[id][gExp] = SQL_ReadResult(szSelect, 4)
				UserData[id][gBonus] = SQL_ReadResult(szSelect, 5)
				szPlayerMysql[id] = true

				break
	        } else {
				SQL_NextRow(szSelect)
	        }
	    }

	    if(!szPlayerMysql[id])
	    {
	        new Handle:szInsert
	        szInsert = SQL_PrepareQuery(MYSQL_Connect, "INSERT INTO `asystem` (`as_steam`, `as_nick`, `as_lvl`, `as_exp`, `as_bonus`) VALUES  ('%s', '%s', '0', '0', '0');", gSteamId[id], szName)

	        if(!SQL_Execute(szInsert))
	        {
				set_task(1.0, "cmdGetInfo", id)
				check_level(id)
	        }
		
	        set_task(1.0, "cmdGetInfo", id)
	        check_level(id)
	        szPlayerMysql[id] = true
	    }
	
	    while(UserData[id][gExp] >= gLevels[UserData[id][gLevel]]) 
	    {
	        UserData[id][gLevel]++;
	    }
	} else {
	    new s_GetLvl[40], s_GetExp[40], s_GetBonus[40]
	
	    formatex(s_GetLvl, charsmax(s_GetLvl), "%sRANK", gSteamId[id])
	    new s_Level = nvault_get(gVault, s_GetLvl)
	
	    formatex(s_GetExp, charsmax(s_GetExp), "%sEXP", gSteamId[id])
	    new s_Exp = nvault_get(gVault, s_GetExp)
	
	    formatex(s_GetBonus, charsmax(s_GetBonus), "%sBONUS", gSteamId[id])
	    new s_Bonus = nvault_get(gVault, s_GetBonus)
	
	    if(s_Level)
	    {
	        UserData[id][gLevel] = s_Level
	        UserData[id][gExp] = s_Exp
	        UserData[id][gBonus] = s_Bonus
	    } else {
	        cmdSaveInfo(id)
	    }
	}
	
	return PLUGIN_HANDLED
}

public EventDeath()
{
	new iKiller = read_data(1);
	new iVictim = read_data(2);
	new iHead = read_data(3);
	new gMsg[255]
	
	set_dhudmessage(get_pcvar_num(cl_r), get_pcvar_num(cl_g), get_pcvar_num(cl_b), 0.57, 0.75, 0, 3.0, 1.0, 0.1, 0.1)
	
	if( iHead && iKiller != iVictim && is_user_connected(iKiller) && is_user_connected(iVictim) && UserData[iKiller][gLevel] <= 19 )
	{
		UserData[iKiller][gExp] += get_pcvar_num(exp2)
		UserData[iKiller][gBonus] += 2
		
		format(gMsg, charsmax(gMsg), "%L", LANG_PLAYER, "AS_KILL1", get_pcvar_num(exp2))
	} else 
	if( iKiller != iVictim && is_user_connected(iKiller) && is_user_connected(iVictim) && UserData[iKiller][gLevel] <= 19 )
	{
		UserData[iKiller][gExp] += get_pcvar_num(exp1)
		UserData[iKiller][gBonus] += 1
		
	    format(gMsg, charsmax(gMsg), "%L", LANG_PLAYER, "AS_KILL2", get_pcvar_num(exp1))
	}
	
	if(get_pcvar_num(gNiceP))
		niceP[iKiller][frags]++

	
	check_level(iKiller);
	
	show_dhudmessage(iKiller, gMsg)
	
	return PLUGIN_CONTINUE;
}

public check_level(id)
{
	if(UserData[id][gLevel] <= 0)
		UserData[id][gLevel] = 1;
		
	if(UserData[id][gExp] < 0)
		UserData[id][gExp] = 0;

	while(UserData[id][gExp] >= gLevels[UserData[id][gLevel]]) 
	{
		UserData[id][gLevel]++;
		static buffer[192]
		
		new szName[33]
		get_user_name(id, szName, 32)
		
		format(buffer, charsmax(buffer), "%s %L!t %s!y %L!t %L", cPrefix, id, "AS_MSG3", szName, id, "AS_MSG4", id, gRankNames[UserData[id][gLevel]]) 
		ChatColor(0, buffer);
	}
}

public Info()
{
	for(new id = 0; id <= gMaxPlayers; id++)
	{
		if(!is_user_bot(id) && is_user_connected(id))
		{
		    static buffer[192]
		    if ( get_pcvar_num(g_Informer) == 1 )
			{
				set_hudmessage(get_pcvar_num(cl_r), get_pcvar_num(cl_g), get_pcvar_num(cl_b), 0.01, 0.20, 0, 15.0, 1.0, _, _, -1)
			
				static len;
				len = format(buffer, charsmax(buffer), "%L ", id, "AS_MSG0");
				len += format(buffer[len], charsmax(buffer) - len, " %L ", id, gRankNames[UserData[id][gLevel]]);
				if(UserData[id][gLevel] <= 19)
				{
					len += format(buffer[len], charsmax(buffer) - len, "^n%L [ %d / %d ]", id, "AS_MSG1", UserData[id][gExp], gLevels[UserData[id][gLevel]]);
				} else {
					len += format(buffer[len], charsmax(buffer) - len, "^n%L", id, "AS_MSG2");
				}
			} else 
			if ( get_pcvar_num(g_Informer) == 0 )
			{
			    
				set_hudmessage(get_pcvar_num(cl_r), get_pcvar_num(cl_g), get_pcvar_num(cl_b), -1.0, 0.89, 0, 15.0, 1.0, _, _, -1)
				format(buffer, charsmax(buffer), "%L %L | %L %d / %d", id, "AS_MSG0", id, "AS_MSG1", id, gRankNames[UserData[id][gLevel]], UserData[id][gExp], gLevels[UserData[id][gLevel]]);
			}
			
			ShowSyncHudMsg(id, g_MsgHud, "%s", buffer);
		}
	}
	
	return PLUGIN_CONTINUE
}

public plugin_init()
{
    register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event("DeathMsg", "EventDeath", "a")
	RegisterHam(Ham_TakeDamage, "player", "hook_TakeDamage")
	register_logevent("event_round_end", 2, "1=Round_End")
	register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
	
	g_Informer = register_cvar("as_informer", "1")
	
	gType = register_cvar("as_type", "1")
	
	exp1 = register_cvar("as_exp_1", "1")
	exp2 = register_cvar("as_exp_2", "2")
	
	cl_r = register_cvar("as_color_r", "255")
	cl_g = register_cvar("as_color_g", "255")
	cl_b = register_cvar("as_color_b", "255")
	
	gNiceP = register_cvar("as_nice_player", "1")
	
	if ( get_pcvar_num(gNiceP) )
	{
	    nMoney = register_cvar("as_nice_money", "500")
		nExp = register_cvar("as_nice_exp", "3")
	}
	
	if(get_pcvar_num(gType))
	{
		gMySQL[1] = register_cvar("as_hostname", "127.0.0.1")
		gMySQL[2] = register_cvar("as_username", "root")
		gMySQL[3] = register_cvar("as_password", "")
		gMySQL[4] = register_cvar("as_database", "army_system")
	} else {
		gDelDay = register_cvar("as_nvault_delday", "5")
	}
	
	gMaxPlayers = get_maxplayers()
	g_MsgHud = CreateHudSyncObj()
	
	set_task(1.0, "Info", _, _, _, "b")
	
	if(get_pcvar_num(gType))
		set_task(1.0, "MYSQL_Load")
	
	register_dictionary("as_lang.txt")
}

stock ChatColor(const id, const input[], any:...)
{
	new count = 1, players[32]
	static msg[188]
	vformat(msg, 187, input, 3)
	
	replace_all(msg, 187, "!g", "^4")
	replace_all(msg, 187, "!y", "^1")
	replace_all(msg, 187, "!t", "^3")
	
	if (id) players[0] = id; else get_players(players, count, "ch")
	{
		for (new i = 0; i < count; i++)
		{
			if (is_user_connected(players[i]))
			{
				message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i]);
				write_byte(players[i]);
				write_string(msg);
				message_end();
			}
		}
	}
}